/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.io.OutputStream;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.rest.RestProducerBindingProcessor;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RestProducerBindingProcessorTest {
    final AsyncCallback callback = (AsyncCallback)Mockito.mock(AsyncCallback.class);
    final CamelContext context = new DefaultCamelContext();
    final DataFormat jsonDataFormat = (DataFormat)Mockito.mock(DataFormat.class);
    final DataFormat outJsonDataFormat = (DataFormat)Mockito.mock(DataFormat.class);
    final DataFormat outXmlDataFormat = (DataFormat)Mockito.mock(DataFormat.class);
    final AsyncProcessor processor = (AsyncProcessor)Mockito.mock(AsyncProcessor.class);
    final DataFormat xmlDataFormat = (DataFormat)Mockito.mock(DataFormat.class);

    @Test
    public void shouldMarshalAndUnmarshalJson() throws Exception {
        String outType = ResponsePojo.class.getName();
        RestProducerBindingProcessor bindingProcessor = new RestProducerBindingProcessor(this.processor, this.context, this.jsonDataFormat, this.xmlDataFormat, this.outJsonDataFormat, this.outXmlDataFormat, "json", true, outType);
        DefaultExchange exchange = new DefaultExchange(this.context);
        DefaultMessage input = new DefaultMessage(this.context);
        RequestPojo request = new RequestPojo();
        input.setBody((Object)request);
        exchange.setIn((Message)input);
        ResponsePojo response = new ResponsePojo();
        Mockito.when((Object)this.outJsonDataFormat.unmarshal((Exchange)ArgumentMatchers.same((Object)exchange), ArgumentMatchers.any(Object.class))).thenReturn((Object)response);
        ArgumentCaptor bindingCallback = ArgumentCaptor.forClass(AsyncCallback.class);
        Mockito.when((Object)this.processor.process((Exchange)ArgumentMatchers.same((Object)exchange), (AsyncCallback)bindingCallback.capture())).thenReturn((Object)false);
        bindingProcessor.process((Exchange)exchange, this.callback);
        ((DataFormat)Mockito.verify((Object)this.jsonDataFormat)).marshal((Exchange)ArgumentMatchers.same((Object)exchange), ArgumentMatchers.same((Object)request), (OutputStream)ArgumentMatchers.any(OutputStream.class));
        Assertions.assertNotNull((Object)bindingCallback.getValue());
        AsyncCallback that = (AsyncCallback)bindingCallback.getValue();
        that.done(false);
        Assertions.assertSame((Object)response, (Object)exchange.getMessage().getBody());
    }

    @Test
    public void shouldMarshalAndUnmarshalXml() throws Exception {
        String outType = ResponsePojo.class.getName();
        RestProducerBindingProcessor bindingProcessor = new RestProducerBindingProcessor(this.processor, this.context, this.jsonDataFormat, this.xmlDataFormat, this.outJsonDataFormat, this.outXmlDataFormat, "xml", true, outType);
        DefaultExchange exchange = new DefaultExchange(this.context);
        DefaultMessage input = new DefaultMessage(this.context);
        RequestPojo request = new RequestPojo();
        input.setBody((Object)request);
        exchange.setIn((Message)input);
        ResponsePojo response = new ResponsePojo();
        Mockito.when((Object)this.outXmlDataFormat.unmarshal((Exchange)ArgumentMatchers.same((Object)exchange), ArgumentMatchers.any(Object.class))).thenReturn((Object)response);
        ArgumentCaptor bindingCallback = ArgumentCaptor.forClass(AsyncCallback.class);
        Mockito.when((Object)this.processor.process((Exchange)ArgumentMatchers.same((Object)exchange), (AsyncCallback)bindingCallback.capture())).thenReturn((Object)false);
        bindingProcessor.process((Exchange)exchange, this.callback);
        ((DataFormat)Mockito.verify((Object)this.xmlDataFormat)).marshal((Exchange)ArgumentMatchers.same((Object)exchange), ArgumentMatchers.same((Object)request), (OutputStream)ArgumentMatchers.any(OutputStream.class));
        Assertions.assertNotNull((Object)bindingCallback.getValue());
        AsyncCallback that = (AsyncCallback)bindingCallback.getValue();
        that.done(false);
        Assertions.assertSame((Object)response, (Object)exchange.getMessage().getBody());
    }

    @Test
    public void shouldNotMarshalAndUnmarshalByDefault() {
        String outType = ResponsePojo.class.getName();
        RestProducerBindingProcessor bindingProcessor = new RestProducerBindingProcessor(this.processor, this.context, this.jsonDataFormat, this.xmlDataFormat, this.outJsonDataFormat, this.outXmlDataFormat, "off", true, outType);
        DefaultExchange exchange = new DefaultExchange(this.context);
        DefaultMessage input = new DefaultMessage(this.context);
        RequestPojo request = new RequestPojo();
        input.setBody((Object)request);
        exchange.setIn((Message)input);
        ArgumentCaptor bindingCallback = ArgumentCaptor.forClass(AsyncCallback.class);
        Mockito.when((Object)this.processor.process((Exchange)ArgumentMatchers.same((Object)exchange), (AsyncCallback)bindingCallback.capture())).thenReturn((Object)false);
        bindingProcessor.process((Exchange)exchange, this.callback);
        Assertions.assertNotNull((Object)bindingCallback.getValue());
        AsyncCallback that = (AsyncCallback)bindingCallback.getValue();
        that.done(false);
    }

    public static class ResponsePojo {
    }

    public static class RequestPojo {
    }
}

