/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.RestComponent;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.component.rest.RestProducer;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.support.DefaultComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestEndpointTest {
    final RestComponent restComponent;
    final CamelContext context = new DefaultCamelContext();

    public RestEndpointTest() {
        this.context.addComponent("mock-rest", (Component)new MockRest());
        this.restComponent = new RestComponent();
        this.restComponent.setCamelContext(this.context);
    }

    @Test
    public void shouldConfigureBindingMode() throws Exception {
        RestEndpoint restEndpoint = new RestEndpoint("rest:GET:/path", this.restComponent);
        restEndpoint.setConsumerComponentName("mock-rest");
        restEndpoint.setParameters(new HashMap());
        restEndpoint.setHost("http://localhost");
        restEndpoint.setBindingMode("json");
        RestProducer producer = (RestProducer)restEndpoint.createProducer();
        Assertions.assertEquals((Object)"json", (Object)producer.getBindingMode().name());
    }

    @Test
    public void shouldCreateQueryParametersFromUnusedEndpointParameters() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("host", "http://localhost");
        parameters.put("bindingMode", "json");
        parameters.put("foo", "bar");
        RestEndpoint endpoint = (RestEndpoint)this.restComponent.createEndpoint("rest:GET:/path?host=http://localhost&bindingMode=json&foo=bar", "GET:/path", parameters);
        Assertions.assertEquals((Object)"http://localhost", (Object)endpoint.getHost());
        Assertions.assertEquals((Object)"json", (Object)endpoint.getBindingMode().name());
        Assertions.assertEquals((Object)"GET", (Object)endpoint.getMethod());
        Assertions.assertEquals((Object)"/path", (Object)endpoint.getPath());
        Assertions.assertEquals((Object)"foo=bar", (Object)endpoint.getQueryParameters());
    }

    @Test
    public void shouldSupportQueryParametersSetViaEndpointUri() throws Exception {
        RestEndpoint endpoint = (RestEndpoint)this.context.getComponent("rest").createEndpoint("rest:GET:/path?host=http://localhost&bindingMode=json&foo=bar&queryParameters=RAW(a%3Db%26c%3Dd)");
        Assertions.assertEquals((Object)"http://localhost", (Object)endpoint.getHost());
        Assertions.assertEquals((Object)"json", (Object)endpoint.getBindingMode().name());
        Assertions.assertEquals((Object)"GET", (Object)endpoint.getMethod());
        Assertions.assertEquals((Object)"/path", (Object)endpoint.getPath());
        Assertions.assertEquals((Object)"foo=bar&a=b&c=d", (Object)endpoint.getQueryParameters());
    }

    public static class MockRest
    extends DefaultComponent
    implements RestProducerFactory {
        public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) {
            return null;
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return null;
        }
    }
}

