/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.rest.RestComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.support.DefaultComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestComponentVerifierTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("rest", (Object)new RestComponent());
        registry.bind("rest-component", (Object)new MyComponent());
        return registry;
    }

    @Test
    public void testParameters() {
        RestComponent component = (RestComponent)this.context.getComponent("rest", RestComponent.class);
        ComponentVerifierExtension verifier = component.getVerifier();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("producerComponentName", "rest-component");
        parameters.put("host", "http://localhost:1234");
        parameters.put("path", "verify");
        parameters.put("method", "get");
        parameters.put("authProxy", "http://localhost:8080");
        ComponentVerifierExtension.Result result = verifier.verify(ComponentVerifierExtension.Scope.PARAMETERS, parameters);
        Assertions.assertEquals((Object)ComponentVerifierExtension.Result.Status.OK, (Object)result.getStatus());
    }

    @Test
    public void testMissingParameters() {
        RestComponent component = (RestComponent)this.context.getComponent("rest", RestComponent.class);
        ComponentVerifierExtension verifier = component.getVerifier();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("producerComponentName", "rest-component");
        parameters.put("host", "http://localhost:1234");
        parameters.put("path", "verify");
        parameters.put("authProxy", "http://localhost:8080");
        ComponentVerifierExtension.Result result = verifier.verify(ComponentVerifierExtension.Scope.PARAMETERS, parameters);
        Assertions.assertEquals((Object)ComponentVerifierExtension.Result.Status.ERROR, (Object)result.getStatus());
        Assertions.assertEquals((int)1, (int)result.getErrors().size());
        Assertions.assertEquals((Object)ComponentVerifierExtension.VerificationError.StandardCode.MISSING_PARAMETER, (Object)((ComponentVerifierExtension.VerificationError)result.getErrors().get(0)).getCode());
        Assertions.assertEquals((int)1, (int)((ComponentVerifierExtension.VerificationError)result.getErrors().get(0)).getParameterKeys().size());
        Assertions.assertTrue((boolean)((ComponentVerifierExtension.VerificationError)result.getErrors().get(0)).getParameterKeys().contains("method"));
    }

    private static final class MyComponent
    extends DefaultComponent
    implements RestProducerFactory,
    RestConsumerFactory {
        public MyComponent() {
            this.registerExtension((ComponentExtension)new ComponentVerifierExtension(){

                public ComponentVerifierExtension.Result verify(ComponentVerifierExtension.Scope scope, Map<String, Object> parameters) {
                    return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)scope).error(ResultErrorHelper.requiresOption(parameters, (String)"authProxy")).build();
                }
            });
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }
    }
}

