/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.component.rest.RestComponent;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RestComponentTest {
    private RestComponent rest;

    @BeforeEach
    public void createSubjects() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getRegistry().bind("host-ref", (Object)"http://localhost:8080");
        this.rest = new RestComponent();
        this.rest.setCamelContext((CamelContext)context);
    }

    @Test
    public void shouldResolveHostParameterAsReference() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("host", "#host-ref");
        RestEndpoint endpoint = (RestEndpoint)this.rest.createEndpoint("rest://GET:/path:?host=#host-ref", "GET:/path", parameters);
        Assertions.assertEquals((Object)"http://localhost:8080", (Object)endpoint.getHost());
    }

    @Test
    public void shouldResolveHostParameterAsGivenValue() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("host", "http://localhost:8080");
        RestEndpoint endpoint = (RestEndpoint)this.rest.createEndpoint("rest://GET:/path:?host=http%3A%2F%2Flocalhost%3A8080", "GET:/path", parameters);
        Assertions.assertEquals((Object)"http://localhost:8080", (Object)endpoint.getHost());
    }
}

