/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestPathPlaceholderTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    protected int getExpectedNumberOfRoutes() {
        return 1;
    }

    @Test
    public void testPlaceholder() {
        Assertions.assertEquals((int)this.getExpectedNumberOfRoutes(), (int)this.context.getRoutes().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        Assertions.assertNotNull((Object)rest);
        Assertions.assertEquals((Object)"/say/{{mypath}}", (Object)rest.getPath());
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://get-say-hello"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                FromRestPathPlaceholderTest.this.context.getPropertiesComponent().addInitialProperty("mypath", "hello");
                this.restConfiguration().host("localhost");
                this.rest("/say/{{mypath}}").get().to("direct:hello");
                this.from("direct:hello").log("Hello");
            }
        };
    }
}

