/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestInlineRoutesTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    protected int getExpectedNumberOfRoutes() {
        return 2;
    }

    @Test
    public void testInlined() {
        Assertions.assertEquals((int)this.getExpectedNumberOfRoutes(), (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)2, (int)this.context.getRestDefinitions().size());
        Assertions.assertEquals((int)2, (int)this.context.getRouteDefinitions().size());
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"Me", String.class);
        Assertions.assertEquals((Object)"Hello World", (Object)out);
        String out2 = (String)this.template.requestBody("seda:get-say-bye", (Object)"Me", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out2);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost").inlineRoutes(true);
                this.rest("/say/hello").get().to("direct:hello");
                this.rest("/say/bye").get().to("direct:bye");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

