/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.FromRestGetTest;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.VerbDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestIdAndDescriptionTest
extends FromRestGetTest {
    @Override
    @Test
    public void testFromRestModel() throws Exception {
        super.testFromRestModel();
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        Assertions.assertEquals((Object)"hello", (Object)rest.getId());
        Assertions.assertEquals((Object)"Hello Service", (Object)rest.getDescriptionText());
        Assertions.assertEquals((Object)"get-say", (Object)((VerbDefinition)rest.getVerbs().get(0)).getId());
        Assertions.assertEquals((Object)"Says hello to you", (Object)((VerbDefinition)rest.getVerbs().get(0)).getDescriptionText());
        RestDefinition rest2 = (RestDefinition)this.context.getRestDefinitions().get(1);
        Assertions.assertEquals((Object)"bye", (Object)rest2.getId());
        Assertions.assertEquals((Object)"Bye Service", (Object)rest2.getDescriptionText());
        Assertions.assertEquals((Object)"Says bye to you", (Object)((VerbDefinition)rest2.getVerbs().get(0)).getDescriptionText());
        Assertions.assertEquals((Object)"Updates the bye message", (Object)((VerbDefinition)rest2.getVerbs().get(1)).getDescriptionText());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                FromRestIdAndDescriptionTest.this.context.getPropertiesComponent().addInitialProperty("mySpecialId", "scott");
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").id("hello").description("Hello Service").get().id("get-say").description("Says hello to you").to("direct:hello");
                this.rest("/say/bye").id("bye").description("Bye Service").get().id("{{mySpecialId}}").description("Says bye to you").consumes("application/json").param().type(RestParamType.header).description("header param description1").dataType("integer").allowableValues(new String[]{"1", "2", "3", "4"}).defaultValue("1").name("header_count").required(Boolean.valueOf(true)).endParam().param().type(RestParamType.query).description("header param description2").dataType("string").allowableValues(new String[]{"a", "b", "c", "d"}).defaultValue("b").collectionFormat(CollectionFormat.multi).name("header_letter").required(Boolean.valueOf(false)).endParam().responseMessage().code(300).message("test msg").responseModel(Integer.class).header("rate").description("Rate limit").dataType("integer").endHeader().endResponseMessage().responseMessage().code("error").message("does not work").endResponseMessage().to("direct:bye").post().description("Updates the bye message").to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

