/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.ValueDefinition;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.ParamDefinition;
import org.apache.camel.model.rest.ResponseHeaderDefinition;
import org.apache.camel.model.rest.ResponseMessageDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestGetTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    protected int getExpectedNumberOfRoutes() {
        return 3;
    }

    @Test
    public void testFromRestModel() throws Exception {
        Assertions.assertEquals((int)this.getExpectedNumberOfRoutes(), (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)2, (int)this.context.getRestDefinitions().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        Assertions.assertNotNull((Object)rest);
        Assertions.assertEquals((Object)"/say/hello", (Object)rest.getPath());
        Assertions.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestGetTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        Assertions.assertEquals((Object)"direct:hello", (Object)to.getUri());
        rest = (RestDefinition)this.context.getRestDefinitions().get(1);
        Assertions.assertNotNull((Object)rest);
        Assertions.assertEquals((Object)"/say/bye", (Object)rest.getPath());
        Assertions.assertEquals((int)2, (int)rest.getVerbs().size());
        Assertions.assertEquals((Object)"application/json", (Object)((VerbDefinition)rest.getVerbs().get(0)).getConsumes());
        Assertions.assertEquals((Object)"{{mySpecialId}}", (Object)((VerbDefinition)rest.getVerbs().get(0)).getId());
        Assertions.assertEquals((int)2, (int)((VerbDefinition)rest.getVerbs().get(0)).getParams().size());
        Assertions.assertEquals((Object)RestParamType.header, (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getType());
        Assertions.assertEquals((Object)RestParamType.query, (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getType());
        Assertions.assertEquals((Object)"header param description1", (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getDescription());
        Assertions.assertEquals((Object)"header param description2", (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getDescription());
        Assertions.assertEquals((Object)"integer", (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getDataType());
        Assertions.assertEquals((Object)"string", (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getDataType());
        Assertions.assertEquals((Object)"1", (Object)((ValueDefinition)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getAllowableValues().get(0)).getValue());
        Assertions.assertEquals((Object)"2", (Object)((ValueDefinition)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getAllowableValues().get(1)).getValue());
        Assertions.assertEquals((Object)"3", (Object)((ValueDefinition)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getAllowableValues().get(2)).getValue());
        Assertions.assertEquals((Object)"4", (Object)((ValueDefinition)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getAllowableValues().get(3)).getValue());
        Assertions.assertEquals((Object)"a", (Object)((ValueDefinition)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getAllowableValues().get(0)).getValue());
        Assertions.assertEquals((Object)"b", (Object)((ValueDefinition)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getAllowableValues().get(1)).getValue());
        Assertions.assertEquals((Object)"c", (Object)((ValueDefinition)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getAllowableValues().get(2)).getValue());
        Assertions.assertEquals((Object)"d", (Object)((ValueDefinition)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getAllowableValues().get(3)).getValue());
        Assertions.assertEquals((Object)"1", (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getDefaultValue());
        Assertions.assertEquals((Object)"b", (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getDefaultValue());
        Assertions.assertNull((Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getCollectionFormat());
        Assertions.assertEquals((Object)CollectionFormat.multi, (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getCollectionFormat());
        Assertions.assertEquals((Object)"header_count", (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getName());
        Assertions.assertEquals((Object)"header_letter", (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getName());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getRequired());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)((ParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getRequired());
        Assertions.assertEquals((Object)"300", (Object)((ResponseMessageDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(0)).getCode());
        Assertions.assertEquals((Object)"rate", (Object)((ResponseHeaderDefinition)((ResponseMessageDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(0)).getHeaders().get(0)).getName());
        Assertions.assertEquals((Object)"Rate limit", (Object)((ResponseHeaderDefinition)((ResponseMessageDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(0)).getHeaders().get(0)).getDescription());
        Assertions.assertEquals((Object)"integer", (Object)((ResponseHeaderDefinition)((ResponseMessageDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(0)).getHeaders().get(0)).getDataType());
        Assertions.assertEquals((Object)"error", (Object)((ResponseMessageDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(1)).getCode());
        Assertions.assertEquals((Object)"test msg", (Object)((ResponseMessageDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(0)).getMessage());
        Assertions.assertEquals((Object)Integer.class.getCanonicalName(), (Object)((ResponseMessageDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(0)).getResponseModel());
        to = FromRestGetTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        Assertions.assertEquals((Object)"direct:bye", (Object)to.getUri());
        this.getMockEndpoint("mock:update").expectedMessageCount(1);
        this.template.sendBody("seda:post-say-bye", (Object)"I was here");
        this.assertMockEndpointsSatisfied();
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"Me", String.class);
        Assertions.assertEquals((Object)"Hello World", (Object)out);
        String out2 = (String)this.template.requestBody("seda:get-say-bye", (Object)"Me", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out2);
        if (this.context.getPropertiesComponent().resolveProperty("mySpecialId").isPresent()) {
            Route route = this.context.getRoute("scott");
            Assertions.assertNotNull((Object)route);
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                FromRestGetTest.this.context.getPropertiesComponent().addInitialProperty("mySpecialId", "scott");
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").get().to("direct:hello");
                this.rest("/say/bye").get().id("{{mySpecialId}}").consumes("application/json").param().type(RestParamType.header).description("header param description1").dataType("integer").allowableValues(new String[]{"1", "2", "3", "4"}).defaultValue("1").name("header_count").required(Boolean.valueOf(true)).endParam().param().type(RestParamType.query).description("header param description2").dataType("string").allowableValues(new String[]{"a", "b", "c", "d"}).defaultValue("b").collectionFormat(CollectionFormat.multi).name("header_letter").required(Boolean.valueOf(false)).endParam().responseMessage().code(300).message("test msg").responseModel(Integer.class).header("rate").description("Rate limit").dataType("integer").endHeader().endResponseMessage().responseMessage().code("error").message("does not work").endResponseMessage().to("direct:bye").post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

