/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestGetPolicyTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    @Test
    public void testFromRestModel() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)1, (int)this.context.getRestDefinitions().size());
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        this.template.sendBody("seda:get-say-hello", null);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").get().to("direct:hello");
                this.from("direct:hello").policy((Policy)new MyDummyPolicy()).to("mock:hello");
            }
        };
    }

    private static class MyDummyPolicy
    implements Policy {
        private MyDummyPolicy() {
        }

        public void beforeWrap(Route route, NamedNode definition) {
        }

        public Processor wrap(Route route, Processor processor) {
            return processor;
        }
    }
}

