/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.ParamDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestGetPlaceholderParamTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return answer;
    }

    @Test
    public void testFromRestModelSingleParam() {
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        Assertions.assertNotNull((Object)rest);
        Assertions.assertEquals((Object)"items/", (Object)rest.getPath());
        Assertions.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestGetPlaceholderParamTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        Assertions.assertEquals((Object)"direct:hello", (Object)to.getUri());
        List paramDefinitions = ((VerbDefinition)rest.getVerbs().get(0)).getParams();
        Assertions.assertEquals((int)1, (int)paramDefinitions.size());
        Assertions.assertEquals((Object)RestParamType.path, (Object)((ParamDefinition)paramDefinitions.get(0)).getType());
        Assertions.assertEquals((Object)"id", (Object)((ParamDefinition)paramDefinitions.get(0)).getName());
    }

    @Test
    public void testFromRestModelMultipleParams() {
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(1);
        Assertions.assertNotNull((Object)rest);
        Assertions.assertEquals((Object)"items/", (Object)rest.getPath());
        Assertions.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestGetPlaceholderParamTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        Assertions.assertEquals((Object)"direct:hello", (Object)to.getUri());
        List paramDefinitions = ((VerbDefinition)rest.getVerbs().get(0)).getParams();
        Assertions.assertEquals((int)3, (int)paramDefinitions.size());
        Assertions.assertEquals((Object)RestParamType.path, (Object)((ParamDefinition)paramDefinitions.get(0)).getType());
        Assertions.assertEquals((Object)"id", (Object)((ParamDefinition)paramDefinitions.get(0)).getName());
        Assertions.assertEquals((Object)RestParamType.path, (Object)((ParamDefinition)paramDefinitions.get(1)).getType());
        Assertions.assertEquals((Object)"filename", (Object)((ParamDefinition)paramDefinitions.get(1)).getName());
        Assertions.assertEquals((Object)RestParamType.path, (Object)((ParamDefinition)paramDefinitions.get(2)).getType());
        Assertions.assertEquals((Object)"content-type", (Object)((ParamDefinition)paramDefinitions.get(2)).getName());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost");
                this.rest("items/").get("/{id}").to("direct:hello");
                this.rest("items/").get("{id}/{filename}.{content-type}").to("direct:hello");
                this.from("direct:hello").transform().constant((Object)"Hello World");
            }
        };
    }
}

