/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestGetInterceptFromTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    @Test
    public void testFromRestModel() throws Exception {
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:intercept").expectedMessageCount(1);
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"I was here", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost").inlineRoutes(true);
                this.interceptFrom("rest:*").to("mock:intercept");
                this.rest("/say/hello").get().to("direct:hello");
                ((RouteDefinition)((RouteDefinition)this.from("direct:hello").to("mock:hello")).to("mock:bar")).transform().constant((Object)"Bye World");
            }
        };
    }
}

