/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestGetHttpErrorCodeTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    @Test
    public void testFromRestModel() {
        String out = (String)this.template.requestBody("seda:get-say-bye", (Object)"I was here", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        Exchange reply = this.template.request("seda:get-say-bye", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Kaboom");
            }
        });
        Assertions.assertNotNull((Object)reply);
        Assertions.assertEquals((Object)404, (Object)reply.getMessage().getHeader("CamelHttpResponseCode"));
        Assertions.assertEquals((Object)"text/plain", (Object)reply.getMessage().getHeader("Content-Type"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost");
                this.rest("/say/bye").get().to("direct:bye");
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:bye").choice().when(this.body().contains((Object)"Kaboom")).setHeader("CamelHttpResponseCode", (Expression)this.constant(404))).setHeader("Content-Type", (Expression)this.constant("text/plain"))).setBody((Expression)this.constant("The data is invalid"))).otherwise().transform().constant((Object)"Bye World");
            }
        };
    }
}

