/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.FromRestGetTest;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestGetEndPathTest
extends FromRestGetTest {
    @Override
    @Test
    public void testFromRestModel() throws Exception {
        Assertions.assertEquals((int)this.getExpectedNumberOfRoutes(), (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)2, (int)this.context.getRestDefinitions().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        Assertions.assertNotNull((Object)rest);
        Assertions.assertEquals((Object)"/say/hello", (Object)rest.getPath());
        Assertions.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestGetEndPathTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        Assertions.assertEquals((Object)"direct:hello", (Object)to.getUri());
        rest = (RestDefinition)this.context.getRestDefinitions().get(1);
        Assertions.assertNotNull((Object)rest);
        Assertions.assertEquals((Object)"/say/bye", (Object)rest.getPath());
        Assertions.assertEquals((int)2, (int)rest.getVerbs().size());
        Assertions.assertEquals((Object)"application/json", (Object)((VerbDefinition)rest.getVerbs().get(0)).getConsumes());
        to = ((VerbDefinition)rest.getVerbs().get(0)).getTo();
        Assertions.assertEquals((Object)"direct:bye", (Object)to.getUri());
        this.getMockEndpoint("mock:update").expectedMessageCount(1);
        this.template.sendBody("seda:post-say-bye", (Object)"I was here");
        this.assertMockEndpointsSatisfied();
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"Me", String.class);
        Assertions.assertEquals((Object)"Hello World", (Object)out);
        String out2 = (String)this.template.requestBody("seda:get-say-bye", (Object)"Me", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out2);
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").get().to("direct:hello");
                this.rest("/say/bye").get().consumes("application/json").to("direct:bye").post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

