/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestGetCorsTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    @Test
    public void testCors() throws Exception {
        this.getMockEndpoint("mock:update").expectedMessageCount(1);
        Exchange out = this.template.request("seda:post-say-bye", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"I was here");
            }
        });
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"*", (Object)out.getMessage().getHeader("Access-Control-Allow-Origin"));
        Assertions.assertEquals((Object)"GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH", (Object)out.getMessage().getHeader("Access-Control-Allow-Methods"));
        Assertions.assertEquals((Object)"Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers", (Object)out.getMessage().getHeader("Access-Control-Allow-Headers"));
        Assertions.assertEquals((Object)"3600", (Object)out.getMessage().getHeader("Access-Control-Max-Age"));
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost").enableCORS(true);
                this.rest("/say/hello").get().to("direct:hello");
                this.rest("/say/bye").get().consumes("application/json").to("direct:bye").post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

