/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestGetContentTypeTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    @Test
    public void testFromRestModelContentType() {
        Exchange out = this.template.request("seda:get-say-hello", new Processor(){

            public void process(Exchange exchange) {
            }
        });
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"{ \"name\" : \"Donald\" }", (Object)out.getMessage().getBody());
        Assertions.assertEquals((Object)"application/json", (Object)out.getMessage().getHeader("Content-Type"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").produces("application/json").get().to("direct:hello");
                this.from("direct:hello").setBody((Expression)this.constant("{ \"name\" : \"Donald\" }"));
            }
        };
    }
}

