/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestDuplicateTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    @Test
    public void testDuplicateGet() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost");
                this.rest("/users").get("{id}").to("log:foo").post().to("log:foo").get("").to("log:foo").get("{id}").to("log:foo");
            }
        }), (String)"Should throw exception");
        Assertions.assertEquals((Object)"Duplicate verb detected in rest-dsl: get:{id}", (Object)e.getMessage());
    }

    @Test
    public void testDuplicatePost() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost");
                this.rest("/users").get("{id}").to("log:foo").post().to("log:foo").get("").to("log:foo").put().to("log:foo").post().to("log:foo");
            }
        }), (String)"Should throw exception");
        Assertions.assertEquals((Object)"Duplicate verb detected in rest-dsl: post", (Object)e.getMessage());
    }
}

