/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.CamelContextHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestDisabledTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    @Test
    public void testDisabled() throws Exception {
        this.getMockEndpoint("mock:bye").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:get-say-bye", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)0, (int)CamelContextHelper.getEndpoints((CamelContext)this.context, e -> e.getEndpointUri().contains("hi")).size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost");
                this.rest("/say").post("/hi").to("mock:hi").disabled().get("/bye").to("mock:bye").get("/translate").to("mock:translate");
            }
        };
    }
}

