/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class FromRestDefaultValueTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    @Test
    public void testDefaultValue() throws Exception {
        this.getMockEndpoint("mock:bye").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bye").expectedHeaderReceived("kind", (Object)"customer");
        this.template.sendBody("seda:get-say-bye", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDefaultHeaderValue() throws Exception {
        this.getMockEndpoint("mock:bye").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bye").expectedHeaderReceived("indicator", (Object)"disabled");
        this.template.sendBody("seda:get-say-bye", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDefaultValueOverride() throws Exception {
        this.getMockEndpoint("mock:bye").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:bye").expectedHeaderReceived("kind", (Object)"admin");
        this.template.sendBodyAndHeader("seda:get-say-bye", (Object)"Bye World", "kind", (Object)"admin");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDefaultHeaderValueOverride() throws Exception {
        this.getMockEndpoint("mock:bye").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:bye").expectedHeaderReceived("indicator", (Object)"enabled");
        this.template.sendBodyAndHeader("seda:get-say-bye", (Object)"Bye World", "indicator", (Object)"enabled");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost").enableCORS(true);
                this.rest("/say/bye").consumes("application/json").get().param().type(RestParamType.query).name("kind").defaultValue("customer").endParam().param().type(RestParamType.header).name("indicator").defaultValue("disabled").endParam().to("mock:bye");
            }
        };
    }
}

