/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.component.rest.FromRestGetTest;
import org.apache.camel.impl.FooBar;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestConfigurationTest
extends FromRestGetTest {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myDummy", (Object)new FooBar());
        return jndi;
    }

    @Override
    @Test
    public void testFromRestModel() {
        Assertions.assertEquals((Object)"dummy-rest", (Object)this.context.getRestConfiguration().getComponent());
        Assertions.assertEquals((Object)"localhost", (Object)this.context.getRestConfiguration().getHost());
        Assertions.assertEquals((int)9090, (int)this.context.getRestConfiguration().getPort());
        Assertions.assertEquals((Object)"bar", this.context.getRestConfiguration().getComponentProperties().get("foo"));
        Assertions.assertEquals((Object)"stuff", this.context.getRestConfiguration().getComponentProperties().get("other"));
        Assertions.assertEquals((Object)"200", this.context.getRestConfiguration().getEndpointProperties().get("size"));
        Assertions.assertEquals((Object)"1000", this.context.getRestConfiguration().getConsumerProperties().get("pollTimeout"));
        Assertions.assertEquals((Object)"#myDummy", this.context.getRestConfiguration().getConsumerProperties().get("dummy"));
        DummyRestConsumerFactory factory = (DummyRestConsumerFactory)this.context.getRegistry().lookupByName("dummy-rest");
        Object dummy = this.context.getRegistry().lookupByName("myDummy");
        Assertions.assertSame((Object)dummy, (Object)factory.getDummy());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().component("dummy-rest").host("localhost").port(9090).componentProperty("foo", "bar").componentProperty("other", "stuff").endpointProperty("size", "200").consumerProperty("pollTimeout", "1000").consumerProperty("dummy", "#myDummy");
                this.rest("/say/hello").get().to("log:hello");
            }
        };
    }
}

