/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.component.rest.DummyRestProcessorFactory;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestApiTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        jndi.bind("dummy-rest-api", (Object)new DummyRestProcessorFactory());
        return jndi;
    }

    @Test
    public void testFromRestModel() {
        Assertions.assertEquals((int)1, (int)this.context.getRestDefinitions().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        Assertions.assertNotNull((Object)rest);
        Assertions.assertEquals((Object)"/say/hello", (Object)rest.getPath());
        Assertions.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestApiTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        Assertions.assertEquals((Object)"log:hello", (Object)to.getUri());
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost").component("dummy-rest").apiContextPath("/api");
                this.rest("/say/hello").get().to("log:hello");
            }
        };
    }
}

