/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromRestAdviceWithTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAdviceWith() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.rest("/say/hello").get().to("direct:hello");
                ((ProcessorDefinition)this.from("direct:hello").routeId("myRoute").transform().constant((Object)"Bye World")).to("mock:hello");
            }
        });
        RouteDefinition route = this.context.getRouteDefinition("myRoute");
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.replaceFromWith("direct:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        String out = (String)this.template.requestBody("direct:foo", (Object)"I was here", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.assertMockEndpointsSatisfied();
    }
}

