/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ref;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RefInvalidTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("ref:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalid() {
        Exception ex = (Exception)Assertions.assertThrows(ResolveEndpointFailedException.class, () -> this.template.sendBody("ref:xxx", (Object)"Hello World"), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"Failed to resolve endpoint: ref://xxx due to: No bean could be found in the registry for: xxx of type: org.apache.camel.Endpoint", (Object)ex.getMessage());
        NoSuchBeanException cause = RefInvalidTest.assertIsInstanceOf(NoSuchBeanException.class, ex.getCause());
        Assertions.assertEquals((Object)"xxx", (Object)cause.getName());
    }

    @Override
    protected CamelContext createCamelContext() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getRegistry().bind("foo", (Object)context.getEndpoint("seda:foo"));
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("ref:foo").routeId("foo").to("mock:result");
            }
        };
    }
}

