/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ref;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RefFileEndpointTest
extends ContextTestSupport {
    @Test
    public void testRefFileEndpoint() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        FileConsumer consumer = (FileConsumer)this.context.getRoute("foo").getConsumer();
        Assertions.assertEquals((long)3000L, (long)consumer.getDelay());
        Assertions.assertEquals((long)250L, (long)consumer.getInitialDelay());
    }

    @Override
    protected CamelContext createCamelContext() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getRegistry().bind("foo", (Object)context.getEndpoint(this.fileUri("?initialDelay=250&delay=3000&delete=true")));
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("ref:foo").routeId("foo").to("mock:result");
            }
        };
    }
}

