/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ref;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class RefComponentTest
extends ContextTestSupport {
    private void setupComponent() throws Exception {
        DirectComponent comp = new DirectComponent();
        comp.setCamelContext((CamelContext)this.context);
        Endpoint slow = comp.createEndpoint("direct:somename");
        Consumer consumer = slow.createConsumer(new Processor(){

            public void process(Exchange exchange) {
                RefComponentTest.this.template.send("mock:result", exchange);
            }
        });
        consumer.start();
        this.context.getRegistry().bind("foo", (Object)slow);
    }

    @Test
    public void testRef() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.setupComponent();
        this.template.sendBody("ref:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

