/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.spi.PropertiesComponent;
import org.junit.jupiter.api.Test;

public class XPathPropertyPlaceholderTest
extends ContextTestSupport {
    @Test
    public void testFilter() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:output-filter");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:filter", (Object)"<greeting><text>Hello, world!</text></greeting>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testChoice() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:output-choice");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:choice", (Object)"<greeting><text>Bye, world!</text></greeting>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testChoice2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:output-choice2");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:choice2", (Object)"<greeting><text>Bye, world!</text></greeting>");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Properties prop = new Properties();
                prop.put("foo", "//greeting/text = 'Hello, world!'");
                prop.put("bar", "//greeting/text = 'Bye, world!'");
                PropertiesComponent pc = XPathPropertyPlaceholderTest.this.context.getPropertiesComponent();
                pc.setInitialProperties(prop);
                ((ExpressionNode)((FilterDefinition)this.from("direct:filter").filter().xpath("{{foo}}")).log("Passed filter!")).to("mock:output-filter");
                ((ChoiceDefinition)this.from("direct:choice").choice().when((Predicate)this.xpath("{{bar}}")).log("Passed choice!")).to("mock:output-choice");
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:choice2").choice().when().xpath("{{bar}}")).log("Passed choice2!")).to("mock:output-choice2");
            }
        };
    }
}

