/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.PropertiesFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyFunctionOptionalPropertyPlaceholderTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testNoFunctionNotPresent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setBody().constant((Object)"{{?myKey}}")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").allMessages().body()).isNull();
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.getMockEndpoint("mock:result").getReceivedExchanges().size());
    }

    @Test
    public void testNoFunctionPresent() throws Exception {
        Properties prop = new Properties();
        prop.put("myKey", "123");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setBody().constant((Object)"{{?myKey}}")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"123", "123"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.getMockEndpoint("mock:result").getReceivedExchanges().size());
    }

    @Test
    public void testFunctionNotPresent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setBody().constant((Object)"{{reverse:?myKey}}")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").allMessages().body()).isNull();
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.getMockEndpoint("mock:result").getReceivedExchanges().size());
    }

    @Test
    public void testFunctionMagic() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setBody().constant((Object)"{{magic:myMagic}}")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").allMessages().body()).isEqualTo((Object)"magic");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.getMockEndpoint("mock:result").getReceivedExchanges().size());
    }

    @Test
    public void testFunctionMagicOptional() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setBody().constant((Object)"{{magic:myOptional}}")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").allMessages().body()).isNull();
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.getMockEndpoint("mock:result").getReceivedExchanges().size());
    }

    @Test
    public void testFunctionPresent() throws Exception {
        Properties prop = new Properties();
        prop.put("myKey", "123");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setBody().constant((Object)"{{reverse:?myKey}}")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"321", "321"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testKeepUnresolved() {
        String out = this.context.getCamelContextExtension().resolvePropertyPlaceholders("{{reverse:?myKey}}", true);
        Assertions.assertEquals((Object)"{{?myKey}}", (Object)out);
    }

    @Test
    public void testQueryOptionalNotPresent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result?retainFirst={{reverse:?maxKeep}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.getMockEndpoint("mock:result").getReceivedExchanges().size());
    }

    @Test
    public void testQueryOptionalPresent() throws Exception {
        this.context.getPropertiesComponent().addInitialProperty("maxKeep", "321");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result?retainFirst={{reverse:?maxKeep}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result?retainFirst=123").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.getMockEndpoint("mock:result?retainFirst=123").getReceivedExchanges().size());
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        ReverseFunction func = new ReverseFunction();
        func.setCamelContext(context);
        context.getPropertiesComponent().addPropertiesFunction((PropertiesFunction)func);
        MagicFunction func2 = new MagicFunction();
        func2.setCamelContext(context);
        context.getPropertiesComponent().addPropertiesFunction((PropertiesFunction)func2);
        return context;
    }

    private static class ReverseFunction
    implements PropertiesFunction,
    CamelContextAware {
        private CamelContext camelContext;

        private ReverseFunction() {
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public String getName() {
            return "reverse";
        }

        public boolean lookupFirst(String remainder) {
            return true;
        }

        public String apply(String remainder) {
            if (remainder == null || remainder.isEmpty()) {
                return remainder;
            }
            StringBuilder sb = new StringBuilder(remainder);
            return sb.reverse().toString();
        }
    }

    private static class MagicFunction
    implements PropertiesFunction,
    CamelContextAware {
        private CamelContext camelContext;

        private MagicFunction() {
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public String getName() {
            return "magic";
        }

        public String apply(String remainder) {
            return "myMagic".equals(remainder) ? "magic" : null;
        }

        public boolean optional(String remainder) {
            return "myOptional".equals(remainder);
        }
    }
}

