/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.support.PluginHelper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesRouteFromTest
extends ContextTestSupport {
    @Test
    public void testPropertiesRouteFrom() throws Exception {
        ProcessorDefinition out = (ProcessorDefinition)this.context.getRouteDefinition("foo").getOutputs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{{cool.end}}", (Object)((SendDefinition)out).getUri());
        String uri = this.context.getRouteDefinition("foo").getInput().getUri();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{{cool.start}}", (Object)uri);
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("foo"));
        Assertions.assertThat((String)xml).containsPattern((CharSequence)"\\Q<from id=\"\\Efrom[0-9]+\\Q\" uri=\"{{cool.start}}\"/>\\E");
        Assertions.assertThat((String)xml).containsPattern((CharSequence)"\\Q<to id=\"\\Eto[0-9]+\\Q\" uri=\"{{cool.end}}\"/>\\E");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("{{cool.start}}").routeId("foo").to("{{cool.end}}");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }
}

