/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class PropertiesComponentServiceHostPortTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testFunction() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).transform().constant((Object)"{{service.host:FOO}}:{{service.port:FOO}}")).to("mock:bar");
            }
        });
        this.context.start();
        String body = System.getenv("FOO_SERVICE_HOST") + ":" + System.getenv("FOO_SERVICE_PORT");
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFunctionGetOrElse() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).transform().constant((Object)"{{service.host:BAR:myotherserver}}:{{service.port:BAR:8888}}")).to("mock:bar");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"myotherserver:8888"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

