/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesResolvedValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentResolvedValueTest
extends ContextTestSupport {
    @Test
    public void testResolved() {
        PropertiesComponent pc = this.context.getPropertiesComponent();
        Assertions.assertTrue((boolean)pc.getResolvedValue("unknown").isEmpty());
        Assertions.assertTrue((boolean)pc.getResolvedValue("greeting").isPresent());
        Assertions.assertTrue((boolean)pc.getResolvedValue("cool.end").isPresent());
        Assertions.assertTrue((boolean)pc.getResolvedValue("place").isPresent());
        Assertions.assertTrue((boolean)pc.getResolvedValue("myserver").isPresent());
        PropertiesResolvedValue p = (PropertiesResolvedValue)pc.getResolvedValue("greeting").get();
        Assertions.assertEquals((Object)"greeting", (Object)p.name());
        Assertions.assertEquals((Object)"Hello World", (Object)p.originalValue());
        Assertions.assertEquals((Object)"Hello World", (Object)p.value());
        Assertions.assertEquals((Object)"Hi", (Object)p.defaultValue());
        Assertions.assertEquals((Object)"InitialProperties", (Object)p.source());
        p = (PropertiesResolvedValue)pc.getResolvedValue("cool.end").get();
        Assertions.assertEquals((Object)"cool.end", (Object)p.name());
        Assertions.assertEquals((Object)"mock:result", (Object)p.originalValue());
        Assertions.assertEquals((Object)"mock:result", (Object)p.value());
        Assertions.assertNull((Object)p.defaultValue());
        Assertions.assertEquals((Object)"classpath:org/apache/camel/component/properties/myproperties.properties", (Object)p.source());
        p = (PropertiesResolvedValue)pc.getResolvedValue("place").get();
        Assertions.assertEquals((Object)"place", (Object)p.name());
        Assertions.assertEquals((Object)"Paris", (Object)p.originalValue());
        Assertions.assertEquals((Object)"Paris", (Object)p.value());
        Assertions.assertEquals((Object)"Paris", (Object)p.defaultValue());
        Assertions.assertNull((Object)p.source());
        p = (PropertiesResolvedValue)pc.getResolvedValue("myserver").get();
        Assertions.assertEquals((Object)"myserver", (Object)p.name());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)p.value());
        Assertions.assertEquals((Object)"{{env:MY_SERVER:127.0.0.1}}", (Object)p.originalValue());
        Assertions.assertNull((Object)p.defaultValue());
        Assertions.assertEquals((Object)"env", (Object)p.source());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").setBody((Expression)this.constant("{{greeting:Hi}}"))).setHeader("bar", (Expression)this.constant("{{?place:Paris}}"))).setHeader("server", (Expression)this.constant("{{myserver}}"))).to("{{cool.end}}");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        context.getPropertiesComponent().addInitialProperty("greeting", "Hello World");
        context.getPropertiesComponent().addInitialProperty("myserver", "{{env:MY_SERVER:127.0.0.1}}");
        return context;
    }
}

