/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.File;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentReloadPropertiesTest
extends ContextTestSupport {
    private String name;
    private String name2;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testReloadProperties() throws Exception {
        this.context.start();
        PropertiesComponent pc = this.context.getPropertiesComponent();
        Properties prop = pc.loadProperties();
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((int)2, (int)prop.size());
        Assertions.assertEquals((Object)"10", (Object)prop.getProperty("myQueueSize"));
        Assertions.assertEquals((Object)"Moes", (Object)prop.getProperty("bar"));
        IOHelper.writeText((String)"myQueueSize = 20\nsay=cheese", (File)new File(this.name));
        IOHelper.writeText((String)"bar = Jacks", (File)new File(this.name2));
        boolean reloaded = pc.reloadProperties(null);
        Assertions.assertTrue((boolean)reloaded);
        prop = pc.loadProperties();
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((int)3, (int)prop.size());
        Assertions.assertEquals((Object)"20", (Object)prop.getProperty("myQueueSize"));
        Assertions.assertEquals((Object)"cheese", (Object)prop.getProperty("say"));
        Assertions.assertEquals((Object)"Jacks", (Object)prop.getProperty("bar"));
    }

    @Test
    public void testReloadPropertiesPattern() throws Exception {
        this.context.start();
        PropertiesComponent pc = this.context.getPropertiesComponent();
        Properties prop = pc.loadProperties();
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((int)2, (int)prop.size());
        Assertions.assertEquals((Object)"10", (Object)prop.getProperty("myQueueSize"));
        Assertions.assertEquals((Object)"Moes", (Object)prop.getProperty("bar"));
        IOHelper.writeText((String)"myQueueSize = 20\nsay=cheese", (File)new File(this.name));
        IOHelper.writeText((String)"bar = Jacks", (File)new File(this.name2));
        boolean reloaded = pc.reloadProperties("file:" + this.name);
        Assertions.assertTrue((boolean)reloaded);
        prop = pc.loadProperties();
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((int)3, (int)prop.size());
        Assertions.assertEquals((Object)"20", (Object)prop.getProperty("myQueueSize"));
        Assertions.assertEquals((Object)"cheese", (Object)prop.getProperty("say"));
        Assertions.assertEquals((Object)"Moes", (Object)prop.getProperty("bar"));
    }

    @Test
    public void testReloadNotMatch() {
        this.context.start();
        PropertiesComponent pc = this.context.getPropertiesComponent();
        Properties prop = pc.loadProperties();
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((int)2, (int)prop.size());
        Assertions.assertEquals((Object)"10", (Object)prop.getProperty("myQueueSize"));
        Assertions.assertEquals((Object)"Moes", (Object)prop.getProperty("bar"));
        boolean reloaded = pc.reloadProperties("file:foo.properties");
        Assertions.assertFalse((boolean)reloaded);
        prop = pc.loadProperties();
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((int)2, (int)prop.size());
        Assertions.assertEquals((Object)"10", (Object)prop.getProperty("myQueueSize"));
        Assertions.assertEquals((Object)"Moes", (Object)prop.getProperty("bar"));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        this.name = this.fileUri() + "/myreload.properties";
        this.name = this.name.substring(5);
        IOHelper.writeText((String)"myQueueSize = 10", (File)new File(this.name));
        this.name2 = this.fileUri() + "/myreload2.properties";
        this.name2 = this.name2.substring(5);
        IOHelper.writeText((String)"bar = Moes", (File)new File(this.name2));
        context.getPropertiesComponent().setLocation("file:" + this.name + ",file:" + this.name2);
        return context;
    }
}

