/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.MyDummyBean;
import org.apache.camel.component.bean.MyFooBean;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentRegistryTest
extends ContextTestSupport {
    private MyFooBean foo;
    private MyDummyBean bar;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = (DefaultCamelContext)super.createCamelContext();
        this.foo = new MyFooBean();
        this.bar = new MyDummyBean();
        DefaultRegistry reg = new DefaultRegistry();
        reg.bind("foo", (Object)this.foo);
        reg.bind("bar", (Object)this.bar);
        context.getCamelContextExtension().setRegistry((Registry)reg);
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/cheese.properties");
        return context;
    }

    @Test
    public void testPropertiesComponentRegistryPlain() {
        this.context.start();
        Assertions.assertSame((Object)this.foo, (Object)this.context.getRegistry().lookupByName("foo"));
        Assertions.assertSame((Object)this.bar, (Object)this.context.getRegistry().lookupByName("bar"));
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("unknown"));
    }

    @Test
    public void testPropertiesComponentRegistryLookupName() {
        this.context.start();
        Assertions.assertSame((Object)this.foo, (Object)this.context.getRegistry().lookupByName("{{bean.foo}}"));
        Assertions.assertSame((Object)this.bar, (Object)this.context.getRegistry().lookupByName("{{bean.bar}}"));
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> this.context.getRegistry().lookupByName("{{bean.unknown}}"), (String)"Should have thrown exception");
        IllegalArgumentException cause = PropertiesComponentRegistryTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Property with key [bean.unknown] not found in properties from text: {{bean.unknown}}", (Object)cause.getMessage());
    }

    @Test
    public void testPropertiesComponentRegistryLookupNameAndType() {
        this.context.start();
        Assertions.assertSame((Object)this.foo, (Object)this.context.getRegistry().lookupByNameAndType("{{bean.foo}}", MyFooBean.class));
        Assertions.assertSame((Object)this.bar, (Object)this.context.getRegistry().lookupByNameAndType("{{bean.bar}}", MyDummyBean.class));
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> this.context.getRegistry().lookupByNameAndType("{{bean.unknown}}", MyDummyBean.class), (String)"Should have thrown exception");
        IllegalArgumentException cause = PropertiesComponentRegistryTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Property with key [bean.unknown] not found in properties from text: {{bean.unknown}}", (Object)cause.getMessage());
    }
}

