/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Ordered;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.util.ObjectHelper;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentPropertiesSourceTest {
    @Test
    public void testPropertiesSourceFromRegistry() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getRegistry().bind("my-ps-1", (Object)new PropertiesPropertiesSource("ps1", "my-key-1", "my-val-1"));
        context.getRegistry().bind("my-ps-2", (Object)new PropertiesPropertiesSource("ps2", "my-key-2", "my-val-2"));
        Assertions.assertThat((String)context.resolvePropertyPlaceholders("{{my-key-1}}")).isEqualTo("my-val-1");
        Assertions.assertThat((String)context.resolvePropertyPlaceholders("{{my-key-2}}")).isEqualTo("my-val-2");
    }

    @Test
    public void testOrderedPropertiesSources() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getRegistry().bind("my-ps-1", (Object)new PropertiesPropertiesSource(Integer.MIN_VALUE, "ps1", "shared", "v1", "my-key-1", "my-val-1"));
        context.getRegistry().bind("my-ps-2", (Object)new PropertiesPropertiesSource(2147482647, "ps2", "shared", "v2", "my-key-2", "my-val-2"));
        Map<Object, Object> properties = context.getPropertiesComponent().loadProperties();
        Assertions.assertThat((Object)((Properties)properties).get("my-key-1")).isEqualTo((Object)"my-val-1");
        Assertions.assertThat((Object)((Properties)properties).get("my-key-2")).isEqualTo((Object)"my-val-2");
        Assertions.assertThat((Object)((Properties)properties).get("shared")).isEqualTo((Object)"v1");
        properties = context.getPropertiesComponent().loadPropertiesAsMap();
        Assertions.assertThat((Object)properties.get("my-key-1")).isEqualTo((Object)"my-val-1");
        Assertions.assertThat((Object)properties.get("my-key-2")).isEqualTo((Object)"my-val-2");
        Assertions.assertThat((Object)properties.get("shared")).isEqualTo((Object)"v1");
    }

    @Test
    public void testFilteredPropertiesSources() {
        Properties initial = new Properties();
        initial.put("initial-1", "initial-val-1");
        initial.put("initial-2", "initial-val-2");
        initial.put("my-key-2", "initial-val-2");
        DefaultCamelContext context = new DefaultCamelContext();
        context.getRegistry().bind("my-ps-1", (Object)new PropertiesPropertiesSource("ps1", "my-key-1", "my-val-1"));
        context.getRegistry().bind("my-ps-2", (Object)new PropertiesPropertiesSource("ps2", "my-key-2", "my-val-2"));
        context.getPropertiesComponent().setInitialProperties(initial);
        Map<Object, Object> properties = context.getPropertiesComponent().loadProperties(k -> k.endsWith("-2"));
        Assertions.assertThat((Map)properties).hasSize(2);
        Assertions.assertThat((Object)((Properties)properties).get("initial-2")).isEqualTo((Object)"initial-val-2");
        Assertions.assertThat((Object)((Properties)properties).get("my-key-2")).isEqualTo((Object)"my-val-2");
        properties = context.getPropertiesComponent().loadPropertiesAsMap(k -> k.endsWith("-2"));
        Assertions.assertThat((Map)properties).hasSize(2);
        Assertions.assertThat((Object)properties.get("initial-2")).isEqualTo((Object)"initial-val-2");
        Assertions.assertThat((Object)properties.get("my-key-2")).isEqualTo((Object)"my-val-2");
    }

    @Test
    public void testDisablePropertiesSourceDiscovery() {
        DefaultCamelContext context = new DefaultCamelContext();
        PropertiesComponent pc = (PropertiesComponent)context.getPropertiesComponent();
        pc.setAutoDiscoverPropertiesSources(false);
        context.getRegistry().bind("my-ps-1", (Object)new PropertiesPropertiesSource("ps1", "my-key-1", "my-val-1"));
        context.getRegistry().bind("my-ps-2", (Object)new PropertiesPropertiesSource("ps2", "my-key-2", "my-val-2"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PropertiesComponentPropertiesSourceTest.lambda$testDisablePropertiesSourceDiscovery$2((CamelContext)context)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Property with key [my-key-1] not found in properties from text: {{my-key-1}}");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PropertiesComponentPropertiesSourceTest.lambda$testDisablePropertiesSourceDiscovery$3((CamelContext)context)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Property with key [my-key-2] not found in properties from text: {{my-key-2}}");
    }

    private static /* synthetic */ void lambda$testDisablePropertiesSourceDiscovery$3(CamelContext context) throws Throwable {
        context.resolvePropertyPlaceholders("{{my-key-2}}");
    }

    private static /* synthetic */ void lambda$testDisablePropertiesSourceDiscovery$2(CamelContext context) throws Throwable {
        context.resolvePropertyPlaceholders("{{my-key-1}}");
    }

    private static final class PropertiesPropertiesSource
    extends Properties
    implements LoadablePropertiesSource,
    Ordered {
        private final String name;
        private final int order;

        public PropertiesPropertiesSource(String name, String ... kv) {
            this(2147482647, name, kv);
        }

        public PropertiesPropertiesSource(int order, String name, String ... kv) {
            ObjectHelper.equal((Object)(kv.length % 2), (Object)0);
            this.name = name;
            this.order = order;
            for (int i = 0; i < kv.length; i += 2) {
                super.setProperty(kv[i], kv[i + 1]);
            }
        }

        public String getName() {
            return this.name;
        }

        public int getOrder() {
            return this.order;
        }

        public Properties loadProperties() {
            return this;
        }

        public Properties loadProperties(Predicate<String> filter) {
            Properties props = new Properties();
            for (String name : this.stringPropertyNames()) {
                if (!filter.test(name)) continue;
                props.put(name, this.get(name));
            }
            return props;
        }

        public void reloadProperties(String location) {
        }
    }
}

