/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testPropertiesComponentOnException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:dead");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).header("CamelRedelivered")).isEqualTo((Object)true);
        ((MockValueBuilder)mock.message(0).header("CamelRedeliveryCounter")).isEqualTo((Object)3);
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should throw exception");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).redeliveryDelay("{{delay}}").maximumRedeliveries("{{max}}").to("mock:dead");
                this.from("direct:start").throwException((Exception)new IllegalAccessException("Damn"));
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        Properties cool = new Properties();
        cool.put("delay", "25");
        cool.put("max", "3");
        jndi.bind("myprop", (Object)cool);
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("ref:myprop");
        return context;
    }
}

