/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.PropertiesLookupListener;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentLookupListenerTest
extends ContextTestSupport {
    private final MyListener myListener = new MyListener();

    @Test
    public void testListener() {
        Assertions.assertTrue((boolean)this.myListener.hasName("greeting"));
        Assertions.assertEquals((Object)"Hello World", (Object)this.myListener.getValue("greeting"));
        Assertions.assertEquals((Object)"InitialProperties", (Object)this.myListener.getSource("greeting"));
        Assertions.assertTrue((boolean)this.myListener.hasName("cool.end"));
        Assertions.assertEquals((Object)"mock:result", (Object)this.myListener.getValue("cool.end"));
        Assertions.assertEquals((Object)"classpath:org/apache/camel/component/properties/myproperties.properties", (Object)this.myListener.getSource("cool.end"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setBody((Expression)this.constant("{{greeting}}"))).to("{{cool.end}}");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        context.getPropertiesComponent().addInitialProperty("greeting", "Hello World");
        context.getPropertiesComponent().addPropertiesLookupListener((PropertiesLookupListener)this.myListener);
        return context;
    }

    private static class MyListener
    implements PropertiesLookupListener {
        private final Map<String, String[]> map = new HashMap<String, String[]>();

        private MyListener() {
        }

        public void onLookup(String name, String value, String defaultValue, String source) {
            this.map.put(name, new String[]{value, source});
        }

        public boolean hasName(String name) {
            return this.map.containsKey(name);
        }

        public String getValue(String name) {
            return this.map.get(name)[0];
        }

        public String getSource(String name) {
            return this.map.get(name)[1];
        }
    }
}

