/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentLoadPropertiesFromFileTrimValuesTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        try (BufferedWriter w = Files.newBufferedWriter(this.testFile("space.properties"), new OpenOption[0]);){
            String cool = "cool.leading= Leading space" + LS + "cool.trailing=Trailing space " + LS + "cool.both= Both leading and trailing space " + LS;
            w.write(cool);
            String space = "space.leading=   \\r\\n" + LS + "space.trailing=\\t   " + LS + "space.both=  \\r   \\t  \\n   " + LS;
            w.write(space);
            String mixed = "mixed.leading=   Leading space\\r\\n" + LS + "mixed.trailing=Trailing space\\t   " + LS + "mixed.both=  Both leading and trailing space\\r   \\t  \\n   " + LS;
            w.write(mixed);
            String empty = "empty.line=                               ";
            w.write(empty);
        }
        context.getPropertiesComponent().setLocation(this.fileUri("space.properties"));
        return context;
    }

    @Test
    public void testMustTrimValues() {
        Assertions.assertEquals((Object)"Leading space", (Object)this.context.resolvePropertyPlaceholders("{{cool.leading}}"));
        Assertions.assertEquals((Object)"Trailing space", (Object)this.context.resolvePropertyPlaceholders("{{cool.trailing}}"));
        Assertions.assertEquals((Object)"Both leading and trailing space", (Object)this.context.resolvePropertyPlaceholders("{{cool.both}}"));
        Assertions.assertEquals((Object)"\r\n", (Object)this.context.resolvePropertyPlaceholders("{{space.leading}}"));
        Assertions.assertEquals((Object)"\t", (Object)this.context.resolvePropertyPlaceholders("{{space.trailing}}"));
        Assertions.assertEquals((Object)"\r   \t  \n", (Object)this.context.resolvePropertyPlaceholders("{{space.both}}"));
        Assertions.assertEquals((Object)"Leading space\r\n", (Object)this.context.resolvePropertyPlaceholders("{{mixed.leading}}"));
        Assertions.assertEquals((Object)"Trailing space\t", (Object)this.context.resolvePropertyPlaceholders("{{mixed.trailing}}"));
        Assertions.assertEquals((Object)"Both leading and trailing space\r   \t  \n", (Object)this.context.resolvePropertyPlaceholders("{{mixed.both}}"));
        Assertions.assertEquals((Object)"", (Object)this.context.resolvePropertyPlaceholders("{{empty.line}}"));
    }
}

