/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.PropertiesComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentKeepOnlyChangedTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testChanged() {
        PropertiesComponent pc = this.context.getPropertiesComponent();
        pc.addInitialProperty("foo", "123");
        pc.addInitialProperty("bar", "true");
        Properties p = new Properties();
        p.setProperty("foo", "123");
        p.setProperty("bar", "false");
        pc.keepOnlyChangeProperties(p);
        Assertions.assertEquals((int)1, (int)p.size());
        Assertions.assertEquals((Object)"false", (Object)p.getProperty("bar"));
        p = new Properties();
        p.setProperty("foo", "123");
        p.setProperty("bar", "true");
        pc.keepOnlyChangeProperties(p);
        Assertions.assertEquals((int)0, (int)p.size());
        p = new Properties();
        p.setProperty("foo", "123");
        p.setProperty("bar", "false");
        p.setProperty("cheese", "gauda");
        pc.keepOnlyChangeProperties(p);
        Assertions.assertEquals((int)2, (int)p.size());
        Assertions.assertEquals((Object)"false", (Object)p.getProperty("bar"));
        Assertions.assertEquals((Object)"gauda", (Object)p.getProperty("cheese"));
    }
}

