/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class PropertiesComponentInterceptFromTest
extends ContextTestSupport {
    @Test
    public void testPropertiesComponentInterceptFrom() throws Exception {
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:cool").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.template.sendBody("direct:bar", (Object)"World");
        this.template.sendBody("direct:cool", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptFrom("{{cool.start}}").transform().simple("Bye ${body}");
                this.from("direct:cool").to("mock:cool");
                this.from("direct:bar").to("mock:bar");
            }
        };
    }
}

