/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.support.EndpointHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentIgnoreMissingPropertyTest
extends ContextTestSupport {
    @Test
    public void testIgnoreMissingProperty() {
        Optional o = this.context.getPropertiesComponent().resolveProperty("{{?foo}}");
        Assertions.assertFalse((boolean)o.isEmpty());
        Assertions.assertEquals((Object)"{{?foo}}", o.get());
        o = this.context.getPropertiesComponent().resolveProperty("{{foo}}");
        Assertions.assertFalse((boolean)o.isEmpty());
        Assertions.assertEquals((Object)"{{foo}}", o.get());
        o = this.context.getPropertiesComponent().resolveProperty("{{myQueueSize}}");
        Assertions.assertFalse((boolean)o.isEmpty());
        Assertions.assertEquals((Object)"10", o.get());
        String out = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.context, (String)"{{?foo}}");
        Assertions.assertEquals((Object)"{{?foo}}", (Object)out);
        out = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.context, (String)"{{foo}}");
        Assertions.assertEquals((Object)"{{foo}}", (Object)out);
        out = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.context, (String)"foo:dummy?a=1&b={{foo}}&c={{myQueueSize}}");
        Assertions.assertEquals((Object)"foo:dummy?a=1&b={{foo}}&c=10", (Object)out);
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        context.getPropertiesComponent().setIgnoreMissingProperty(true);
        return context;
    }
}

