/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesComponentFunctionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testFunction() throws Exception {
        MyFunction func = new MyFunction();
        PropertiesComponent pc = (PropertiesComponent)this.context.getPropertiesComponent();
        pc.addPropertiesFunction((PropertiesFunction)func);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:{{sys:os.name}}")).to("{{beer:FOO}}")).to("{{beer:BAR}}");
            }
        });
        this.context.start();
        Assertions.assertTrue((boolean)func.isStarted());
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertTrue((boolean)func.isStopped());
    }

    public static final class MyFunction
    extends ServiceSupport
    implements PropertiesFunction {
        public String getName() {
            return "beer";
        }

        public String apply(String remainder) {
            return "mock:" + remainder.toLowerCase();
        }
    }
}

