/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class PropertiesComponentEIPRoutingSlipTest
extends ContextTestSupport {
    @Test
    public void testRoutingSlip() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "cheese", (Object)"mock:foo##mock:bar");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routingSlip((Expression)this.header("cheese"), "{{slipDelimiter}}");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }
}

