/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class PropertiesComponentEIPChoiceSimpleTest
extends ContextTestSupport {
    @Test
    public void testChoice() throws Exception {
        this.getMockEndpoint("mock:camel").expectedBodiesReceived(new Object[]{"Hello Camel", "Hi Camel"});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)this.context.resolvePropertyPlaceholders("Hello {{cool.name}}"));
        this.template.sendBody("direct:start", (Object)this.context.resolvePropertyPlaceholders("Hi {{cool.name}}"));
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.simple("${body} contains '{{cool.name}}'")).to("mock:camel")).otherwise().to("mock:other");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }
}

