/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.nio.charset.StandardCharsets;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class PropertiesComponentEIPChoiceConvertBodyToTest
extends ContextTestSupport {
    @Test
    public void testConvertToBytesCharset() throws Exception {
        byte[] body = "Hello World".getBytes(StandardCharsets.ISO_8859_1);
        this.getMockEndpoint("mock:null").expectedMessageCount(0);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNullBody() throws Exception {
        this.getMockEndpoint("mock:null").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().isNotNull()).convertBodyTo(byte[].class, "{{myCoolCharset}}")).to("mock:result")).otherwise().to("mock:null");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }
}

