/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Test;

public class PropertiesComponentDisableDefaultsTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testDisableDefaultValueResolution() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").transform().simple("{{p:message}}")).to("mock:{{p:mockend}}");
            }
        });
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedBodiesReceived(new Object[]{"my message"});
        this.context.start();
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Properties props = new Properties();
        props.put("p:mockend", "end");
        props.put("p:message", "my message");
        PropertiesComponent pc = (PropertiesComponent)context.getPropertiesComponent();
        pc.setDefaultFallbackEnabled(false);
        pc.setInitialProperties(props);
        return context;
    }
}

