/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="java.lang.System.properties")
public class PropertiesComponentDefaultFunctionsTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private static Map.Entry<String, String> anyNonEmptyEnvironmentVariable() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            return entry;
        }
        throw new IllegalStateException();
    }

    @Test
    public void testFunction() throws Exception {
        System.setProperty("FOO", "mock:foo");
        final Map.Entry<String, String> env = PropertiesComponentDefaultFunctionsTest.anyNonEmptyEnvironmentVariable();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)((RouteDefinition)this.from("direct:start").to("{{sys:FOO}}")).transform().constant((Object)("{{env:" + (String)env.getKey() + "}}"))).to("mock:bar");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{env.getValue()});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        System.clearProperty("FOO");
    }

    @Test
    public void testFunctionGetOrElse() throws Exception {
        System.setProperty("FOO2", "mock:foo");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("{{sys:FOO2}}")).to("{{env:BAR2:mock:bar}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        System.clearProperty("FOO2");
    }
}

