/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="java.lang.System.properties")
public class PropertiesComponentConcatenatePropertiesTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/concatenation.properties");
        context.getPropertiesComponent().setNestedPlaceholder(true);
        return context;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("environment", "junit");
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("environment");
        super.tearDown();
    }

    @Test
    public void testConcatPropertiesComponentDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setBody((Expression)this.simple("{{concat.property}}"))).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"file:dirname"});
        this.template.sendBody("direct:start", (Object)"Test");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithoutConcatPropertiesComponentDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setBody((Expression)this.simple("{{property.complete}}"))).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"file:dirname"});
        this.template.sendBody("direct:start", (Object)"Test");
        this.assertMockEndpointsSatisfied();
    }
}

