/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionalPropertyPlaceholderTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testQueryOptionalNotPresent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result?retainFirst={{?maxKeep}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.getMockEndpoint("mock:result").getReceivedExchanges().size());
    }

    @Test
    public void testQueryOptionalPresent() throws Exception {
        Properties prop = new Properties();
        prop.put("maxKeep", "1");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result?retainFirst={{?maxKeep}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result?retainFirst=1").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.getMockEndpoint("mock:result?retainFirst=1").getReceivedExchanges().size());
    }

    @Test
    public void testPathOptionalNotPresent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:res{{?unknown}}ult");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPathOptionalPresent() throws Exception {
        Properties prop = new Properties();
        prop.put("whereTo", "result");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:{{?whereTo}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testQueryAndPathOptionalNotPresent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:res{{?unknown}}ult?retainFirst={{?maxKeep}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.getMockEndpoint("mock:result").getReceivedExchanges().size());
    }

    @Test
    public void testQueryAndPathOptionalPresent() throws Exception {
        Properties prop = new Properties();
        prop.put("maxKeep", "1");
        prop.put("whereTo", "result");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:{{?whereTo}}?retainFirst={{?maxKeep}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result?retainFirst=1").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.getMockEndpoint("mock:result?retainFirst=1").getReceivedExchanges().size());
    }

    @Test
    public void testQueryAndPathOptionalMixed() throws Exception {
        Properties prop = new Properties();
        prop.put("maxKeep", "1");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:res{{?unknown}}ult?retainFirst={{?maxKeep}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result?retainFirst=1").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.getMockEndpoint("mock:result?retainFirst=1").getReceivedExchanges().size());
    }

    @Test
    public void testQueryAndPathOptionalMixedTwo() throws Exception {
        Properties prop = new Properties();
        prop.put("whereTo", "result");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:{{?whereTo}}?retainFirst={{?maxKeep}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testQueryWithResourceLoader() throws Exception {
        Properties prop = new Properties();
        prop.put("whereTo", "result");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:{{?whereTo}}?retainFirst=base64:{{?maxBase64}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }
}

