/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class OptionalPropertyPlaceholderEipTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testQueryOptionalNotPresent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.body()).delimiter("{{?myDelim}}").to("mock:line");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:line").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"A,B");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testQueryOptionalPresent() throws Exception {
        Properties prop = new Properties();
        prop.put("myDelim", ";");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.body()).delimiter("{{?myDelim}}").to("mock:line");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:line").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"A,B");
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.getMockEndpoint("mock:line").expectedMessageCount(3);
        this.template.sendBody("direct:start", (Object)"A;B;C");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }
}

