/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.pojo.SayService;
import org.apache.camel.support.PropertyBindingSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionalPropertyPlaceholderBeanTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testQueryOptionalPresent() {
        SayService say = new SayService();
        Assertions.assertEquals((Object)"Hello", (Object)say.getMessage());
        PropertyBindingSupport.build().withTarget((Object)say).withProperty("message", (Object)"{{?cool.name}}").withCamelContext((CamelContext)this.context).bind();
        Assertions.assertEquals((Object)"Camel", (Object)say.getMessage());
    }

    @Test
    public void testQueryOptionalNotPresent() {
        SayService say = new SayService();
        Assertions.assertEquals((Object)"Hello", (Object)say.getMessage());
        PropertyBindingSupport.build().withTarget((Object)say).withProperty("message", (Object)"{{?unknown}}").withCamelContext((CamelContext)this.context).bind();
        Assertions.assertEquals((Object)"Hello", (Object)say.getMessage());
    }

    @Test
    public void testQueryOptionalNotPresentDefaultValue() {
        SayService say = new SayService();
        Assertions.assertEquals((Object)"Hello", (Object)say.getMessage());
        PropertyBindingSupport.build().withTarget((Object)say).withProperty("message", (Object)"{{?unknown:Bye}}").withCamelContext((CamelContext)this.context).bind();
        Assertions.assertEquals((Object)"Bye", (Object)say.getMessage());
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }
}

