/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComponentResolvePropertyPlaceholdersTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testPropertiesComponentEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                SedaComponent seda = new SedaComponent();
                seda.setDefaultPollTimeout(10);
                seda.setQueueSize(((Integer)this.propertyInject("myQueueSize", Integer.TYPE)).intValue());
                ComponentResolvePropertyPlaceholdersTest.this.context.removeComponent("seda");
                ComponentResolvePropertyPlaceholdersTest.this.context.addComponent("seda", (Component)seda);
                this.from("seda:start").to("mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        SedaComponent seda = (SedaComponent)this.context.getComponent("seda", SedaComponent.class);
        Assertions.assertNotNull((Object)seda);
        Assertions.assertEquals((int)10, (int)seda.getQueueSize());
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }
}

