/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.io.ByteArrayInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Test;

public class MockStreamCachingTest
extends ContextTestSupport {
    @Test
    public void testMockStreamCaching() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body(String.class)).contains((Object)"Camel");
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body(String.class)).contains((Object)"World");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello Camel and Bye World".getBytes());
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMockStreamCachingConvertTo() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).convertToString().contains((Object)"Camel");
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).convertToString().contains((Object)"World");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello Camel and Bye World".getBytes());
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").streamCaching().to("mock:result");
            }
        };
    }
}

